<?php
include_once 'db.php';

if (isset($_POST['invoiceid'])) {
    $invoiceId = $_POST['invoiceid'];

    // Debugging: Log the received invoiceId
    error_log("Received invoiceId: $invoiceId");

    try {
        // Query to get the grand total and calculate the due amount
        $query = "
            SELECT 
                ins.grandtotal AS grandtotal, 
                c.displayname AS customername 
            FROM 
                invoice ins 
            INNER JOIN 
                customer c 
            ON 
                c.id = ins.customerid 
            WHERE 
                ins.id = ?
        ";

        $stmt = $conn->prepare($query);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }

        $stmt->bind_param("i", $invoiceId);
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }

        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $data = $result->fetch_assoc();
            $grandtotal = $data['grandtotal'];
            $customername = $data['customername'];

            // Calculate the total customer payment
            $paymentQuery = "
                SELECT 
                    IFNULL(SUM(amount), 0) AS totalcustomerpayment 
                FROM 
                    customerpayment 
                WHERE 
                    invoiceid = ?
            ";

            $paymentStmt = $conn->prepare($paymentQuery);
            if (!$paymentStmt) {
                throw new Exception("Payment prepare failed: " . $conn->error);
            }

            $paymentStmt->bind_param("i", $invoiceId);
            if (!$paymentStmt->execute()) {
                throw new Exception("Payment execute failed: " . $paymentStmt->error);
            }

            $paymentResult = $paymentStmt->get_result();
            $paymentData = $paymentResult->fetch_assoc();
            $totalCustomerPayment = $paymentData['totalcustomerpayment'];

            // Calculate the due amount
            $amount_due = $grandtotal - $totalCustomerPayment;

            // Debugging: Log the calculated due amount
            error_log("Calculated due amount: $amount_due");

            echo json_encode([
                'amount' => $amount_due, 
                'customername' => $customername
            ]);

            $paymentStmt->close();
        } else {
            // Debugging: Log if no rows are returned
            error_log("No rows returned for invoiceId: $invoiceId");
            echo json_encode(['amount' => 0, 'customername' => '']);
        }

        $stmt->close();
    } catch (Exception $e) {
        error_log("Error in payment_fetch.php: " . $e->getMessage());
        http_response_code(500); // Internal Server Error
        echo json_encode(['error' => $e->getMessage()]);
    }
}
$conn->close();
?>
